#include <iostream>
#include <vector>

using namespace std;

void ubaci(vector<float>& t, int k, float x) {
    int j = k - 1;
    while (j >= 0 && x > t[j]) {
        t[j + 1] = t[j];
        j--;
    }
    t[j + 1] = x;
}

float prestizanje(int x[], int v[], int i, int j) {
    if ((x[i] < x[j] && v[i] > v[j]) || (x[j] < x[i] && v[j] > v[i])) {
        return float(abs(x[j] - x[i]) / abs(v[i] - v[j]));
    }
    return 0;
}

int main() {
    int n, k;
    cin >> n >> k;

    vector<int> x(n);
    vector<int> v(n);
    vector<float> t(k);

    for (int i = 0; i < n; i++) {
        cin >> x[i] >> v[i];
    }

    for (int i = 0; i < n; i++) {
        for (int j = i + 1; j < n; j++) {
            float s = prestizanje(x.data(), v.data(), i, j);
            if (s > 0) {
                ubaci(t, k, s);
            }
        }
    }

    cout << t[k - 1];
}